using System;
using System.Xml;
using System.Configuration;
using System.Web;
using System.Web.Profile;
using System.Web.Security;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using XMLProviders;

namespace Helion.CustomProviders.XML
{
   public partial class ProfileProvider : System.Web.Profile.ProfileProvider
   {
      private string profileFile = string.Empty;
      private string name = string.Empty;
      private ProfileDataSet profileData = null;
      private string applicationName = string.Empty;

      public override void Initialize(string name,
          System.Collections.Specialized.NameValueCollection config)
      {
         this.name = name;
         if (config["connectionStringName"] != null)
            profile =
                ConfigurationManager.ConnectionStrings[
                    config["connectionStringName"]].ConnectionString;
         else
            profileFile = @"C:\Helion\Microsoft Visual C# 2005 Unleashed\Chapter29\Profiles.XML";
         if (config["applicationName"] != null)
            applicationName = config["applicationName"];
         else
            applicationName = HttpContext.Current.Request.ApplicationPath;
         InitializeData();
      }

      public override string Description
      {
         get { return "Dostawca profili oparty o XML"; }
      }

      public override string Name
      {
         get { return name; }
      }

      public override int DeleteInactiveProfiles(ProfileAuthenticationOption
          authenticationOption, DateTime userInactiveSinceDate)
      {
         string query = string.Format(
             "ApplicationName='{0}' AND LastActivityDate <= '{1}'",
             applicationName, userInactiveSinceDate);

         int totalRecords;
         ProfileDataSet.ProfilesRow[] profiles = QueryProfiles(query,
             authenticationOption, 0, Int32.MaxValue, out totalRecords);
         foreach (ProfileDataSet.ProfilesRow profile in profiles)
         {
            profile.Delete();
         }
         SaveData();
         return totalRecords;
      }

      public override int DeleteProfiles(string[] usernames)
      {
         int x = 0;
         foreach (string user in usernames)
         {
            ProfileDataSet.ProfilesRow profile = GetProfileByUserName(user);
            profile.Delete();
            x++;
         }
         SaveData();
         return x;
      }

      public override int DeleteProfiles(ProfileInfoCollection profiles)
      {
         int x = 0;
         foreach (ProfileInfo pi in profiles)
         {
            ProfileDataSet.ProfilesRow profile = GetProfileByUserName(pi.UserName);
            profile.Delete();
            x++;
         }
         SaveData();
         return x;
      }

      public override ProfileInfoCollection
      FindInactiveProfilesByUserName(ProfileAuthenticationOption authenticationOption,
          string usernameToMatch,
      DateTime userInactiveSinceDate, int pageIndex, int pageSize,
          out int totalRecords)
      {
         string query = string.Format(
             "UserName='{0}' AND ApplicationName='{1}' AND LastActivityDate <= '{2}'",
             usernameToMatch, applicationName, userInactiveSinceDate);

         ProfileDataSet.ProfilesRow[] profiles = QueryProfiles(
             query, authenticationOption, pageIndex, pageSize, out totalRecords);

         return ProfileRowsToProfileInfoCillection(profiles);
      }

      public override ProfileInfoCollection FindProfilesByUserName(
      ProfileAuthenticationOption
          authenticationOption, string usernameToMatch, int pageIndex,
          int pageSize, out int totalRecords)
      {
         string query = string.Format(
             "UserName='{0}' AND ApplicationName='{1}'",
             usernameToMatch, applicationName);
         ProfileDataSet.ProfilesRow[] profiles = QueryProfiles(
             query, authenticationOption, pageIndex, pageSize, out totalRecords);
         return ProfileRowsToProfileCollection(profiles);
      }

      public override ProfileInfoCollection
      GetAllInactiveProfiles(ProfileAuthenticationOption
          authenticationOption, DateTime userInactiveSinceDate,
          int pageIndex, int pageSize, out int totalRecords)
      {
         string query = string.Format(
             "LastActivityDate <= '{0}' AND ApplicationName='{1}'", userInactiveSinceDate,
             applicationName);
         ProfileDataSet.ProfiesRow[] profiles = QueryProfiles(
             query, authenticationOption, pageIndex, pageSize, out totalRecords);
         return ProfileRowsToProfileInfoCollection(profiles);
      }

      public override ProfileInfoCollection GetAllProfiles(ProfileAuthenticationOption
          authenticationOption, int pageIndex, int pageSize, out int totalRecords)
      {
         string query = string.Format(
             "ApplicationName='{0}'", applicationName);
         ProfileDataSet.ProfiesRow[] profiles = QueryProfiles(
             query, authenticationOption, pageIndex, pageSize, out totalRecords);
         return ProfileRowsToProfileInfoCollection(profiles);
      }

      public override int GetNumberOfInactiveProfiles(ProfileAuthenticationOption
          authenticationOption, DateTime userInactiveSinceDate)
      {
         int totalRecord;
         ProfileInfoCollection pic = GetAllInactiveProfiles(authenticationOption,
             userInactiveSinceDate, 0, Int32.MaxValue, out totalRecords);
         return totalRecords;
      }

      public override string ApplicationName
      {
         get
         {
            return applicationName;
         }
         set
         {
            applicationName = value;
         }
      }

      public override System.Configuration.SettingsPropertyValueCollection
      GetPropertyValues(
          System.Configuration.SettingsContext context,
          System.Configuration.SettingsPropertyCollection collection)
      {
         string userName = (string)context["UserName"];
         bool isAuthenticated = (bool)context["IsAuthenticated"];

         ProfileDataSet.ProfilesRow user = GetProfileByUserName(userName);
         if (user == null)
            user = CreateUserProfile(userName, isAuthenticated);

         SettingsPropertyValueCollection svc = new SettingsPropertyValueCollection();
         foreach (SettingsProperty prop in collection)
         {
            SettingsPropertyValue propValue = new SettingsPropertyValue(prop);
            ProfileDataSet.ProfilePropertiesRow propRow = GetProfileProperty(
                user, prop.Name);
            if (propRow != null)
            {
               propValue.PropertyValue = propRow["PropertyValue"];
            }
            svc.Add(propValue);
         }
         TouchActivityDates(user, true);
         return svc;
      }

      public override void SetPropertyValues(
      System.Configuration.SettingsContext context,
          System.Configuration.SettingsPropertyValueCollection collection)
      {
         string userName = (string)context["UserName"];
         bool isAuthenticated = (bool)context["IsAuthenticated"];
         ProfileDataSet.ProfilesRow user = GetProfileByUserName(userName);
         if (user == null)
            user = CreateUserProfile(userName, isAuthenticated);

         foreach (SettingsPropertyValue propValues in collection)
         {
            ProfileDataSet.ProfilePropertiesRow propRow =
                GetProfileProperty(user, propValue.Name);
            if (propRow != null)
               propRow["PropertyValue"] = propValue.PropertyValue;
            else
            {
               propRow = profileData.ProfileProperties.NewProfilePropertiesRow();
               propRow["UniqueId"] = user.UniqueId;
               propRow["PropertyValue"] = propValue.PropertyValue;
               propRow["PropertyName"] = propValue.Name;
               profileData.ProfileProperties.AddProfilePropertiesRow(propRow);
            }
         }
         SaveData();
         TouchActivityDates(user, false);
      }
   }
}
